import { Tent, Mail, Phone, MapPin, Clock, Facebook, Instagram, MessageCircle } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-outdoor">
      <div className="container">
        <div className="footer-content-outdoor">
          <div className="footer-section-outdoor">
            <div className="footer-logo-outdoor">
              <div className="footer-logo-icon-wrapper-outdoor">
                <Tent className="footer-logo-icon-outdoor" size={24} />
              </div>
              <h2 className="footer-logo-text-outdoor">OUTDOOR RENT</h2>
            </div>
            <p className="footer-description-outdoor">
              Профессиональное оборудование для кемпинга и походов. 
              Качественное снаряжение для ваших приключений на природе.
            </p>
            <div className="footer-social-outdoor">
              <a href="#" className="social-link-outdoor">
                <Instagram size={20} />
              </a>
              <a href="#" className="social-link-outdoor">
                <Facebook size={20} />
              </a>
              <a href="#" className="social-link-outdoor">
                <MessageCircle size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-outdoor">
            <h3 className="footer-title-outdoor">Навигация</h3>
            <ul className="footer-links-outdoor">
              <li><a href="/">Мои аренды</a></li>
              <li><a href="/rent">Арендовать</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section-outdoor">
            <h3 className="footer-title-outdoor">Контакты</h3>
            <ul className="footer-links-outdoor">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@outdoorrent.ru">info@outdoorrent.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Походная, 12</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Вс: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-outdoor">
          <p>&copy; 2025 OUTDOOR RENT. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

